library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity test_pdm_to_pcm is 
end test_pdm_to_pcm;


architecture TB of test_pdm_to_pcm is

component pdm_to_pcm is
port (
  fifo_almost_empty : out STD_LOGIC;
  fifo_almost_full : out STD_LOGIC;
  fifo_rd_clk : in STD_LOGIC;
  fifo_rd_en : in STD_LOGIC;
  pcm_data : out STD_LOGIC_VECTOR (31 downto 0);
  pdm_clk : out STD_LOGIC_VECTOR (0 to 0);
  pdm_data : in STD_LOGIC_VECTOR(3 downto 0);
  resetn : in STD_LOGIC;
  start : in STD_LOGIC;
  sys_clock : in STD_LOGIC
);
end component pdm_to_pcm;

signal fifo_almost_empty : STD_LOGIC;
signal fifo_almost_full : STD_LOGIC;
signal fifo_rd_clk : STD_LOGIC;
signal fifo_rd_en : STD_LOGIC;
signal pcm_data : STD_LOGIC_VECTOR (31 downto 0);
signal pdm_clk : STD_LOGIC_VECTOR (0 to 0);
signal pdm_data : STD_LOGIC_VECTOR(3 downto 0);
signal resetn : STD_LOGIC;
signal start : STD_LOGIC;
signal sys_clock : STD_LOGIC;
begin

DUT: component pdm_to_pcm port map (
  fifo_almost_empty => fifo_almost_empty,
  fifo_almost_full => fifo_almost_full,
  fifo_rd_clk => fifo_rd_clk,
  fifo_rd_en => fifo_rd_en,
  pcm_data => pcm_data,
  pdm_clk => pdm_clk,
  pdm_data => pdm_data,
  resetn => resetn,
  start => start,
  sys_clock => sys_clock
);

process
begin
  fifo_rd_clk <= '0';
  wait for 5.0 ns;
  fifo_rd_clk <= '1';
  wait for 5.0 ns;
end process;
--process
--begin
--  pdm_clk <= "0";
--  wait for 5.0 ns;
--  pdm_clk <= "1";
--  wait for 5.0 ns;
--end process;
process
begin
  sys_clock <= '0';
  wait for 5.0 ns;
  sys_clock <= '1';
  wait for 5.0 ns;
end process;
process
begin
  resetn <= '0';
  wait for 100 ns;
  resetn <= '1';
  wait;
end process;

fifo_rd_en <= '1';
start <= '1';


pdm_data <= "0000",
              "1000" after 1000 ns,
              "1100" after 2000 ns,
              "1110" after 3000 ns,
              "1111" after 4000 ns,
              "0111" after 21000 ns,
              "0011" after 22000 ns,
              "0001" after 23000 ns,
              "0000" after 24000 ns,
              "1000" after 41000 ns,
              "1100" after 42000 ns,
              "1110" after 43000 ns,
              "1111" after 44000 ns,
              "0111" after 61000 ns,
              "0011" after 62000 ns,
              "0001" after 63000 ns,
              "0000" after 64000 ns,
              "1000" after 81000 ns,
              "1100" after 82000 ns,
              "1110" after 83000 ns,
              "1111" after 84000 ns,
              "0111" after 101000 ns,
              "0011" after 102000 ns,
              "0001" after 103000 ns,
              "0000" after 104000 ns,
              "1000" after 121000 ns,
              "1100" after 122000 ns,
              "1110" after 123000 ns,
              "1111" after 124000 ns,
              "0111" after 141000 ns,
              "0011" after 142000 ns,
              "0001" after 143000 ns,
              "0000" after 144000 ns,
              "1000" after 161000 ns,
              "1100" after 162000 ns,
              "1110" after 163000 ns,
              "1111" after 164000 ns,
              "0111" after 181000 ns,
              "0011" after 182000 ns,
              "0001" after 183000 ns,
              "0000" after 184000 ns,
              "1000" after 201000 ns,
              "1100" after 202000 ns,
              "1110" after 203000 ns,
              "1111" after 204000 ns,
              "0111" after 221000 ns,
              "0011" after 222000 ns,
              "0001" after 223000 ns,
              "0000" after 224000 ns;
             



end TB;


